package edu.uky.ai.sl.ex;

import edu.uky.ai.SearchBudget;
import edu.uky.ai.data.LabeledDataSet;
import edu.uky.ai.sl.Learner;
import edu.uky.ai.sl.Model;

/**
 * A supervised machine learner that "learns" a model that always returns a
 * random class label.
 * 
 * @author Your Name
 */
public class ExampleLearner extends Learner {

	/**
	 * Constructs a new random learner. You should change the string below from
	 * "Example" to your ID. You should also change the name of this class. In
	 * Eclipse, you can do that easily by right-clicking on this file
	 * (ExampleLearner.java) in the Package Explorer and choosing
	 * Refactor > Rename.
	 */
	public ExampleLearner() {
		super("example");
	}

	@Override
	public Model learn(LabeledDataSet data, SearchBudget budget) {
		// If the class label is discrete (i.e. Nominal or Ordinal), use a
		// discrete model.
		if(data.labels.isDiscrete())
			return new RandomDiscreteModel(data);
		// Otherwise, the class label is Interval (which is one of two numeric
		// types), so use a numeric model.
		else
			return new RandomNumericModel(data);
	}
}